<?php
if (isset($_FILES['bf_file'])) {
    $errors = array();
    $file_name = $_FILES['bf_file']['name'];
    $file_size = $_FILES['bf_file']['size'];
    $file_tmp = $_FILES['bf_file']['tmp_name'];

    // 파일 확장자 검사
    $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
    
    // 파일 유형별 확장자 목록 정의
    $image_extensions = array("png", "jpeg", "jpg", "webp", "hevc", "heif", "gif");
    $video_extensions = array("mp4", "avi", "m4a", "MP4", "MOV", "mov");
    $other_extensions = array("zip", "txt", "pdf", "MP3");

    $all_extensions = array_merge($image_extensions, $video_extensions, $other_extensions);

    if (!in_array($file_ext, $all_extensions)) {
        $errors[] = "지원하지 않는 파일 형식입니다. " . implode(", ", $all_extensions) . " 형식의 파일만 업로드 가능합니다.";
    }

    // 파일 크기 검사
    $max_image_size_mb = 55; // 55MB
    $max_video_size_mb = 350; // 350MB
    $max_other_size_mb = 30; // 30MB

    // MB를 바이트로 변환
    $max_image_size = $max_image_size_mb * 1024 * 1024;
    $max_video_size = $max_video_size_mb * 1024 * 1024;
    $max_other_size = $max_other_size_mb * 1024 * 1024;

    if ($file_size > $max_image_size && in_array($file_ext, $image_extensions)) {
        $errors[] = "이미지 파일 크기가 너무 큽니다. {$max_image_size_mb}MB 이하의 파일만 업로드 가능합니다.";
    } elseif ($file_size > $max_video_size && in_array($file_ext, $video_extensions)) {
        $errors[] = "동영상 파일 크기가 너무 큽니다. {$max_video_size_mb}MB 이하의 파일만 업로드 가능합니다.";
    } elseif ($file_size > $max_other_size && in_array($file_ext, $other_extensions)) {
        $errors[] = "파일 크기가 너무 큽니다. {$max_other_size_mb}MB 이하의 파일만 업로드 가능합니다.";
    }

    // JavaScript에서 전송한 새로운 파일 이름을 받아옵니다.
    $full_path = $_POST['new_file_name'];
    $path_parts = pathinfo($full_path);
    $directory_name = dirname($full_path) . '/'; // 디렉토리 이름 (보내는회원받는회원/현재년월일)
    $new_file_name = $path_parts['basename']; // 파일 이름 (현재날짜년월일시분초_고유숫자.확장자)

    // 날짜 추출
    $date_from_directory = basename(dirname($full_path)); // 디렉토리에서 날짜 부분 (예: 20241021)
    $date_from_filename = substr($path_parts['filename'], 0, 8); // 파일 이름에서 년월일 부분 (예: 20241020)

    // 현재 서버의 날짜
    $current_date = date('Ymd');

    // 날짜 일치 검사
    if ($date_from_directory !== $current_date) {
        $errors[] = "디렉토리 날짜가 현재 날짜와 일치하지 않습니다.";
    }
    if ($date_from_filename !== $current_date) {
        $errors[] = "파일 이름의 날짜가 현재 날짜와 일치하지 않습니다.";
    }

    // 파일 이름 유효성 검사
    if (empty($new_file_name) || preg_match('/[^A-Za-z0-9_\-\.]/', $new_file_name)) {
        $errors[] = "유효하지 않은 파일 이름입니다.";
    }

    // 디렉토리 이름 유효성 검사 ('.' 포함 여부)
    if (preg_match('/\./', $directory_name)) {
        $errors[] = "디렉토리 이름에 '.' 문자가 포함될 수 없습니다.";
    }

    // 도메인 검증
    $referer_domain = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST);
    $current_domain = $_SERVER['HTTP_HOST'];

    if ($referer_domain !== $current_domain) {
        $errors[] = "허용되지 않은 도메인에서 요청이 발생했습니다.";
    }

    if (empty($errors)) {
        // 데이터 폴더가 존재하는지 확인하고 없으면 생성
        $data_dir = __DIR__ . "/data/" . $directory_name; // 디렉토리 경로 설정
        if (!is_dir($data_dir)) {
            mkdir($data_dir, 0755, true); // 폴더 생성
        }

// 이미지 파일 처리
if (in_array($file_ext, $image_extensions)) {
    $image = imagecreatefromstring(file_get_contents($file_tmp));

    // GIF 파일인 경우 원래의 확장자로 저장
    if ($file_ext == 'gif') {
        $new_file_name = $path_parts['filename'] . '.gif';
        move_uploaded_file($file_tmp, $data_dir . $new_file_name);
    } else {
        // 파일 확장자를 WebP로 변경하여 새 파일명 생성
        $new_file_name = $path_parts['filename'] . '.webp';

        // WebP로 이미지 저장
        imagewebp($image, $data_dir . $new_file_name, 87); // 품질 87로 저장
        imagedestroy($image); // 메모리 해제
    }
} else {
    // 동영상 및 기타 파일은 압축하지 않고 그대로 저장
    move_uploaded_file($file_tmp, $data_dir . $new_file_name);
}


        // rm.php 실행
        require_once 'rm.php';

        echo "성공적으로 업로드 되었습니다.";
    } else {
        // 오류 메시지를 자바스크립트에 전달
        http_response_code(400); // 400 Bad Request
        echo implode(', ', $errors);
    }
}
?>